let uploadButtonText = 'Dokument(e) über Explorer auswählen ...';

// eslint-disable-next-line no-unused-vars
module.exports = showMeta => {
  return {
    type: 'agorum.composite.form.basic',
    name: 'uploadMetaHeaderDetails',
    properties: ['id'],
    /**/
    width: '600',
    // height: '800',
    /**/
    labelPosition: 'top',
    upload: true,
    elements: [
      {
        type: 'agorum.hbox',
        hidden: true,
        items: [
          {
            type: 'agorum.composite.form.element.text',
            name: 'id',
            label: 'Item Id',
            disabled: true,
            width: 140,
          },
          {
            type: 'agorum.composite.form.element.text',
            name: 'name',
            label: 'Item name',
            disabled: true,
            flexible: true,
            optional: true,
          },
        ],
      },
      {
        type: 'agorum.hbox',
        items: [
          {
            type: 'agorum.composite.form.element.text',
            name: 'isg_xpert_archive_insName',
            label: 'Versicherter',
            disabled: true,
            // readOnly: true,
            flexible: true,
          },
          {
            type: 'agorum.composite.form.element.text',
            name: 'isg_xpert_archive_insNumber',
            label: 'KV Nummer',
            disabled: true,
            width: 140,
          },
          {
            type: 'agorum.composite.form.element.date',
            name: 'isg_xpert_archive_insBirthday',
            label: 'Geburtsdatum',
            disabled: true,
            width: 120,
          },
        ],
      },
      {
        type: 'agorum.hbox',
        items: [
          {
            type: 'agorum.composite.form.element.select',
            name: 'isg_xpert_archive_processLvl2',
            label: 'Leistungsbereich',
            restricted: true,
            textIsValue: true,
            disabled: false,
            flexible: true,
            dataSource: 'MAIN_MODULE_MANAGEMENT/customers/isg.xpert.archive/Data/processLvl2',
            validation: [
              {
                required: true,
              },
            ],
          },
          {
            type: 'agorum.composite.form.element.select',
            name: 'isg_xpert_archive_processLvl3',
            label: 'Belegart',
            restricted: true,
            textIsValue: true,
            disabled: false,
            flexible: true,
            dataSource: 'MAIN_MODULE_MANAGEMENT/customers/isg.xpert.archive/Data/processLvl3',
            validation: [
              {
                required: true,
              },
            ],
          },
          {
            type: 'agorum.composite.form.element.select',
            name: 'ordernumber',
            width: 140,
            label: 'Auftrag',
            restricted: true,
            textIsValue: true,
            disabled: false,
            data: [],
            validation: [
              {
                required: true,
              },
            ],
          },
          {
            type: 'agorum.composite.form.element.date',
            name: 'isg_xpert_archive_processDate',
            label: 'Verarbeitungsdatum',
            width: 120,
            disabled: true,
            value: new Date(),
          },
        ],
      },
      {
        type: 'agorum.vbox',
        // lite: true,
        items: [
          {
            type: 'agorum.composite.form.element.select',
            name: 'isg_xpert_archive_class_code',
            label: 'Dokumentenklasse',
            restricted: true,
            dataSource: 'MAIN_MODULE_MANAGEMENT/customers/isg.xpert.archive/Data/class_code',
            // width: 300,
            validation: [
              {
                required: true,
              },
            ],
          },
          {
            type: 'agorum.composite.form.element.select',
            name: 'isg_xpert_archive_type_code',
            label: 'Dokumententyp',
            restricted: true,
            dataSource: 'MAIN_MODULE_MANAGEMENT/customers/isg.xpert.archive/Data/type_code',
            // width: 300,
            validation: [
              {
                required: true,
              },
            ],
          },
          {
            type: 'agorum.composite.form.element.select',
            name: 'isg_xpert_archive_event_code_list',
            label: 'Tätigkeitskennzeichen',
            restricted: true,
            dataSource: 'MAIN_MODULE_MANAGEMENT/customers/isg.xpert.archive/Data/event_code_list',
            // width: 300,
            validation: [
              {
                required: true,
              },
            ],
          },
        ],
      },

      {
        type: 'agorum.vbox',
        name: 'uploadContainer',
        // width: 400,
        height: 200,
        upload: true,
        // cls: 'isg_xpert_archive_div-xpanel_bg-blue-extralight',
        items: [
          {
            name: 'grid',
            type: 'agorum.basicGrid',
            border: true,
            flexible: true,
            cls: 'isg_xpert_archive_div-xpanel_bg-blue-extralight',
            columns: [
              {
                name: 'name',
                text: 'Name',
                flexible: true,
              },
              {
                name: 'progress',
                text: 'Progress',
                width: 100,
              },
            ],
          },
          {
            name: 'uploadButton',
            type: 'agorum.upload',
            text: uploadButtonText,
            icon: 'aguila-icon playlist_add',
          },
        ],
      },
    ],
  };
};
